using System;
using System.Data;
using System.Reflection;

namespace gov.va.med.vbecs.BOL
{
		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary></summary>

		#endregion


	public class Rack : BOL.BaseBusinessObject
	{
		private System.Guid _RackGuid;
		private System.DateTime _dailyQcExpirationDate;
		private bool _dailyUseIndicator;
		private bool _partiallyTestedIndicator;
		private string _rackName;
		private System.Data.DataTable _dtReagents;
		private BOL.DailyControl _dailyControl;
		/// <summary>
		/// Constant containing all of the rack table's field names
		/// </summary>
		public const string RACKCOLUMNS = "RackGuid,DailyControlGuid,DivisionCode," +
			"LastUpdateUser,RowVersion";

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1252"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>A valid Rack object </ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="589"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Empty Rack object constructor
		/// </summary>
		public Rack()
		{
			// Commented out by Stas Antropov: this is obviously a typo. 
			// this.SetInitialBrokenRules("RackGuid");
			//
			// TODO: Add constructor logic here
			//
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/26/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2415"> 
		///		<ExpectedInput>DataRow containing Rack data</ExpectedInput>
		///		<ExpectedOutput>Rack object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2860"> 
		///		<ExpectedInput>Null</ExpectedInput>
		///		<ExpectedOutput>NullReferenceException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Creates Rack object and populates it with data from DataRow
		/// </summary>
		public Rack(DataRow dr)
		{
			this.LoadFromDataRow(dr);
		}

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/27/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6624"> 
		///		<ExpectedInput>Valid GUID</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6625"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get Rack object by Guid
		/// </summary>
		/// <param name="RackGuid"></param>
		public Rack(Guid RackGuid)
		{
			DataRow dr = DAL.Rack.GetRack(RackGuid).Rows[0];
			this.LoadFromDataRow(dr);
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1251"> 
		///		<ExpectedInput>A valid GUID</ExpectedInput>
		///		<ExpectedOutput>A valid GUID</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="640"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Rack's GUID
		/// </summary>
		public System.Guid RackGuid
		{
			get 
			{
				return this._RackGuid;
			}
			set 
			{
				this._RackGuid = value;
			}
		}
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/6/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1607"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1608"> 
		///		<ExpectedInput>Empty String</ExpectedInput>
		///		<ExpectedOutput>Broken Rule</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// The rack name assigned in UC 51 A-Z or 1-26
		/// </summary>
		public string RackName
		{
			get 
			{
				return this._rackName;
			}
			set 
			{
				this._rackName = value;
				//
				RuleBroken(MethodBase.GetCurrentMethod().Name,((_rackName==null)||(_rackName.Length==0)));
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1250"> 
		///		<ExpectedInput>A valid date and time</ExpectedInput>
		///		<ExpectedOutput>>A valid date and time</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="658"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// RackTest's date and time
		/// </summary>
		public System.DateTime DailyQcExpirationDate
		{
			get 
			{
				return this._dailyQcExpirationDate;
			}
			set 
			{
				this._dailyQcExpirationDate = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1249"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>>bool</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="593"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Rack's daily use indicator
		/// </summary>
		public bool DailyUseIndicator
		{
			get 
			{
				return this._dailyUseIndicator;
			}
			set 
			{
				this._dailyUseIndicator = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1248"> 
		///		<ExpectedInput>A valid DataTable object</ExpectedInput>
		///		<ExpectedOutput>>A valid DataTable object</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="669"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// DataTable of reagents the rack uses
		/// </summary>
		public DataTable Reagents
		{
			get
			{
				return this._dtReagents;
			}
			set
			{
				this._dtReagents = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1247"> 
		///		<ExpectedInput>A valid DailyControl object</ExpectedInput>
		///		<ExpectedOutput>>A valid DailyControl object</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="590"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Rack's DailyControl object
        /// </summary>
		public DailyControl DailyControl
		{
			get
			{
			 	return this._dailyControl;
			}
			set
			{
				this._dailyControl = value;
			}
		}
		
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/26/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6532"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6533"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// PartiallyTestedIndicator
		/// </summary>
		public bool PartiallyTestedIndicator
		{
			get
			{
				return this._partiallyTestedIndicator;
			}
			set
			{
				this._partiallyTestedIndicator = value;
			}
		}



		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6663"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6664"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Check if rack was QC'd on or before a given date
		/// Implements BR_51.03
		/// </summary>
		/// <param name="testDate">Test Date</param>
		/// <returns>Tested indicator</returns>
		public bool IsRackQCd(DateTime testDate)
		{
			//BR_51.03
			if (this._dailyQcExpirationDate != DateTime.MinValue)
			{
				if (this._partiallyTestedIndicator == false)
					return true;
				else
					return false;
			}
			else
			{
				return false;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1245"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>A valid DataTable</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="609"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets a data table of daily QC racks for a given division
		/// </summary>
		/// <param name="testDateTime"></param>
		/// <returns></returns>
		public static DataTable GetDailyQCRacks(DateTime testDateTime)
		{
			return(DAL.Rack.GetDailyQCRacks(testDateTime));
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/31/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1557"> 
		///		<ExpectedInput>Rack identifier and DailyUseIndicator</ExpectedInput>
		///		<ExpectedOutput>True</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1976"> 
		///		<ExpectedInput>Invalid rack identifier and DailyUseIndicator</ExpectedInput>
		///		<ExpectedOutput>False</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Updates the DailyUseIndicator of the rack
		/// </summary>
		/// <param name="dailyQcWorklistGuid"></param>
		/// <param name="dailyUseIndicator"></param>
		/// <param name="qcOfflineIndicator"></param>
		/// <param name="lastUpdateFunctionId">UC or calling method</param>
		/// <param name="rowVersion">Row Version</param>
		/// <param name="rackGuid"></param>
		/// <param name="dailyQcExpirationDateTime"></param>
		/// <returns></returns>
		public static bool UpdateRackDailyUse(Guid dailyQcWorklistGuid, bool dailyUseIndicator, bool qcOfflineIndicator,
							Common.UpdateFunction lastUpdateFunctionId, byte[] rowVersion, Guid rackGuid, DateTime dailyQcExpirationDateTime)
		{
			//CR 2718 Added QCOfflineIndicator
			return DAL.Rack.UpdateRackDailyUse(dailyQcWorklistGuid, dailyUseIndicator, qcOfflineIndicator,
												lastUpdateFunctionId, rowVersion, rackGuid, dailyQcExpirationDateTime);
		}

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1513"> 
		///		<ExpectedInput>daily control guid</ExpectedInput>
		///		<ExpectedOutput>A datatable of active rack data associated with the active daily control for the current division </ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1983"> 
		///		<ExpectedInput>Invalid division code, invalid daily control GUID</ExpectedInput>
		///		<ExpectedOutput>Empty data table</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// A datatable of active rack data associated with 
		/// the active daily control for the current division 
		/// is returned from this method
		/// </summary>
		/// <param name="dailyControlGuid"></param>
		/// <returns></returns>
		public static DataTable GetConfigurableRackQC(System.Guid dailyControlGuid)
		{
			return DAL.Rack.GetConfigurableRackQC(dailyControlGuid);
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Loads an object from a data row
		/// </summary>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			if(Common.Utility.VerifyMinColumnsInDataTable(RACKCOLUMNS.Split(','), dtRow.Table))
			{
				this.RackGuid = (System.Guid) dtRow[Common.VbecsTables.Rack.RackGuid];
				if(this.DailyControl != null)
				{
					this.DailyControl.DailyControlGuid = (System.Guid) dtRow[Common.VbecsTables.Rack.DailyControlGuid];
				}
				if(dtRow.Table.Columns.Contains(Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate))
				{
					this.DailyQcExpirationDate = dtRow.IsNull(Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate) ? DateTime.MinValue : Convert.ToDateTime(dtRow[Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate]);
				}
				if(dtRow.Table.Columns.Contains(Common.VbecsTables.DailyQcWorklist.DailyUseIndicator))
				{
					this.DailyUseIndicator = dtRow.IsNull(Common.VbecsTables.DailyQcWorklist.DailyUseIndicator) ? true : (bool) dtRow[Common.VbecsTables.DailyQcWorklist.DailyUseIndicator];
				}
				if(dtRow.Table.Columns.Contains(Common.VbecsTables.Rack.RackName))
				{
					this.RackName = dtRow[Common.VbecsTables.Rack.RackName].ToString();
				}
				if(dtRow.Table.Columns.Contains(Common.VbecsTables.DailyQcWorklist.PartiallyTestedIndicator))
				{
					this.PartiallyTestedIndicator = dtRow.IsNull(Common.VbecsTables.DailyQcWorklist.PartiallyTestedIndicator) ? false : (bool)dtRow[Common.VbecsTables.DailyQcWorklist.PartiallyTestedIndicator];
				}
				if(dtRow.Table.Columns.Contains(Common.VbecsTables.Rack.RowVersion))
				{
					if(!dtRow.IsNull(Common.VbecsTables.Rack.RowVersion))
					{
						this.RowVersion = (byte[]) dtRow[Common.VbecsTables.Rack.RowVersion];
					}
				}
				this.IsNew = false;
			}
			else
			{
				throw new BusinessObjectException(Common.StrRes.SysErrMsg.Common.GeneralError(
					Common.Utility.ParseStringwithSpaces(MethodBase.GetCurrentMethod().Name)).ResString);	
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7645"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7646"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get the date/time of the last qc for rack
		/// </summary>
		/// <param name="dailyQcWorklistGuid"></param>
		/// <returns></returns>
		public static DateTime GetRackTestDate(Guid dailyQcWorklistGuid)
		{
			DataTable dt = DAL.Rack.GetRackTestDate(dailyQcWorklistGuid);
			if (dt.Rows.Count > 0)
				return (DateTime)dt.Rows[0][Common.VbecsTables.RackLot.LotUseDate];
			else
				return DateTime.MinValue;
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1242"> 
		///		<ExpectedInput>Valid data row</ExpectedInput>
		///		<ExpectedOutput>Valid data row</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="638"> 
		///		<ExpectedInput>Invalid DataRow</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///  Loads a data row from an object
		/// </summary>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			if(Common.Utility.VerifyMinColumnsInDataTable(RACKCOLUMNS.Split(','), dtRow.Table))
			{
				dtRow[Common.VbecsTables.Rack.RackGuid] = this.RackGuid;
				if(this.DailyControl != null)
				{
					dtRow[Common.VbecsTables.Rack.DailyControlGuid] = this.DailyControl.DailyControlGuid;
				}
				if(dtRow.Table.Columns.Contains(Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate))
				{
					dtRow[Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate] =this.DailyQcExpirationDate;
				}
				if(dtRow.Table.Columns.Contains(Common.VbecsTables.DailyQcWorklist.DailyUseIndicator))
				{
					dtRow[Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] = this.DailyUseIndicator;
				}
				if(dtRow.Table.Columns.Contains(Common.VbecsTables.Rack.RackName))
				{
					dtRow[Common.VbecsTables.Rack.RackName] = this.RackName;
				}
				if(dtRow.Table.Columns.Contains(Common.VbecsTables.DailyQcWorklist.PartiallyTestedIndicator))
				{
					dtRow[Common.VbecsTables.DailyQcWorklist.PartiallyTestedIndicator] = this.PartiallyTestedIndicator;
				}
				if(dtRow.Table.Columns.Contains(Common.VbecsTables.Rack.RowVersion))
				{
					if(!dtRow.IsNull(Common.VbecsTables.Rack.RowVersion))
					{
						dtRow[Common.VbecsTables.Rack.RowVersion] = this.RowVersion;
					}
				}	
			}
			else
			{
				throw new BusinessObjectException("Error attempting to load data row from rack: \n\n");
			}
			return dtRow;
		}	

	}
}


